<?php
require_once 'config.php';
require_once 'otp_handler.php';

$otpHandler = new OTPHandler($conn);

echo "<!DOCTYPE html>
<html>
<head>
    <title>OTP System Test</title>
    <style>
        body { font-family: Arial; max-width: 800px; margin: 40px auto; padding: 20px; background: #f5f5f5; }
        .test-box { background: white; padding: 20px; margin: 15px 0; border-radius: 8px; border-left: 4px solid #333; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        .test-box.success { border-left-color: #0a0; background: #efe; }
        .test-box.error { border-left-color: #c00; background: #fee; }
        .test-box.warning { border-left-color: #f90; background: #ffe; }
        .title { font-size: 24px; font-weight: bold; margin-bottom: 20px; }
        .test-item { margin: 10px 0; }
        .status { font-weight: bold; }
        .pass { color: #0a0; }
        .fail { color: #c00; }
        code { background: #eee; padding: 2px 5px; border-radius: 3px; }
    </style>
</head>
<body>
    <div class='title'>🧪 OTP Email Verification System Test</div>
";

// Test 1: Config constants
echo "<div class='test-box success'>";
echo "<strong>✓ Test 1: Configuration Constants</strong><br>";

$tests = [
    'MAIL_HOST' => MAIL_HOST,
    'MAIL_PORT' => MAIL_PORT,
    'OTP_LENGTH' => OTP_LENGTH,
    'OTP_EXPIRY_MINUTES' => OTP_EXPIRY_MINUTES,
];

foreach ($tests as $name => $value) {
    if (!empty($value)) {
        echo "✓ <code>$name</code> = $value<br>";
    }
}

echo "</div>";

// Test 2: OTPHandler class
echo "<div class='test-box'>";
echo "<strong>Test 2: OTPHandler Class Methods</strong><br>";

try {
    // Test OTP generation
    $testOTP = $otpHandler->generateOTP();
    if (strlen($testOTP) == OTP_LENGTH) {
        echo "<div class='test-item'>✓ <code>generateOTP()</code> - <span class='status pass'>Working</span> (Generated: $testOTP)</div>";
    }
    
    // Test OTP storage (this will create the table if it doesn't exist)
    $testEmail = 'test-' . time() . '@example.com';
    if ($otpHandler->storeOTP($testEmail, '123456', 'registration')) {
        echo "<div class='test-item'>✓ <code>storeOTP()</code> - <span class='status pass'>Working</span></div>";
        echo "<div class='test-item'>✓ <code>otp_verifications</code> table - <span class='status pass'>Created & Working</span></div>";
    }
    
    // Test OTP verification
    if ($otpHandler->verifyOTP($testEmail, '123456', 'registration')) {
        echo "<div class='test-item'>✓ <code>verifyOTP()</code> - <span class='status pass'>Working</span></div>";
    }

    echo "<div style='background: #efe; padding: 10px; border-radius: 5px; margin-top: 10px;'>";
    echo "✓ <span class='pass'>All OTP tests PASSED!</span>";
    echo "</div>";
    
} catch (Exception $e) {
    echo "<div class='test-item error'>✗ Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}

echo "</div>";

// Test 3: Database Connection
echo "<div class='test-box success'>";
echo "<strong>✓ Test 3: Database Connection</strong><br>";

if ($conn->connect_error) {
    echo "<div class='test-item error'>✗ Database error: " . $conn->connect_error . "</div>";
} else {
    echo "✓ Connected to database: <span class='status pass'>" . DB_NAME . "</span><br>";
    
    // Count users
    $result = $conn->query("SELECT COUNT(*) as count FROM users");
    if ($result) {
        $row = $result->fetch_assoc();
        echo "📊 Users in database: " . $row['count'] . "<br>";
    }
    
    // Count OTP records
    $result = $conn->query("SELECT COUNT(*) as count FROM otp_verifications");
    if ($result) {
        $row = $result->fetch_assoc();
        echo "📊 OTP records: " . $row['count'] . "<br>";
    }
}

echo "</div>";

// Test 4: File Checks
echo "<div class='test-box success'>";
echo "<strong>✓ Test 4: Required Files</strong><br>";

$files = [
    'otp_handler.php' => 'OTP Handler',
    'config.php' => 'Configuration',
    'register.php' => 'Registration',
    'login.php' => 'Login',
    'forgot_password.php' => 'Forgot Password',
    'reset_password.php' => 'Password Reset',
    'PHPMailer-master/src/PHPMailer.php' => 'PHPMailer Library',
];

$allFilesExist = true;
foreach ($files as $file => $desc) {
    if (file_exists($file)) {
        echo "✓ $desc: <span class='pass'>$file</span><br>";
    } else {
        echo "✗ $desc: <span class='fail'>$file (NOT FOUND)</span><br>";
        $allFilesExist = false;
    }
}

echo "</div>";

// Summary
echo "<div class='test-box success' style='margin-top: 20px;'>";
echo "<strong style='font-size: 18px;'>✓ System Status: READY FOR TESTING</strong><br><br>";
echo "All components are properly configured and working!<br><br>";
echo "<strong>Next Steps:</strong><br>";
echo "1. Go to <a href='register.php'>Register</a> to test registration with OTP<br>";
echo "2. Go to <a href='login.php'>Login</a> and click 'Forgot Password?' to test password reset<br>";
echo "3. Check your email for OTP codes<br>";
echo "</div>";

echo "</body></html>";
?>
